# 画面設計書 28-Worker Overview（ワーカー概要）

## 概要

本ドキュメントは、ワーカーノードのリソース情報・実行中エグゼキュータ・ドライバー一覧を表示する画面「Worker Overview（ワーカー概要）」の設計書である。

### 本画面の処理概要

本画面は、Spark Standaloneクラスタの個別ワーカーノードのリソース状況と、そのワーカー上で実行中のエグゼキュータおよびドライバーの詳細情報を表示する画面であり、WorkerWebUIのデフォルト画面である。

**業務上の目的・背景**：Standaloneクラスタの各ワーカーノードのリソース使用状況（CPU、メモリ、カスタムリソース）を個別に確認し、ワーカー上で実行中のエグゼキュータやドライバーの状態を把握することが運用管理上必要である。エグゼキュータの障害発生時にはログへのアクセスが重要であり、本画面はワーカー単位での詳細情報提供とログへのナビゲーションを行う。

**画面へのアクセス方法**：Master Overview画面（No.24）のWorkersテーブルでワーカーIDのリンクをクリックすることで本画面に遷移する。または、直接ワーカーノードのWeb UI URL（http://{worker-host}:{worker-port}/）にアクセスする。

**主要な操作・処理内容**：
1. ワーカー基本情報の表示（ID、Master URL、コア数、メモリ、リソース使用状況）
2. Running Executorsテーブルの表示（実行中エグゼキュータの詳細・ログリンク）
3. Running Driversテーブルの表示（実行中ドライバーの詳細・ログリンク、存在する場合のみ）
4. Finished Executorsテーブルの表示（終了済みエグゼキュータ、存在する場合のみ）
5. Finished Driversテーブルの表示（終了済みドライバー、存在する場合のみ）
6. JSON API応答

**画面遷移**：
- 遷移元：Master Overview画面（No.24）のワーカーID選択
- 遷移先：Worker Log画面（No.29）へエグゼキュータ/ドライバーのログリンク、Spark Application UIへアプリケーション名リンク、Master Overview画面へ「Back to Master」リンク

**権限による表示制御**：特になし。Worker WebUIのアクセス制御に依存する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 17 | Spark Web UI | 主機能 | ワーカーノードのリソース情報・実行中Executor・ドライバー一覧をJSON APIとHTML形式で表示する主処理 |
| 84 | Standaloneクラスタマネージャ | 主機能 | WorkerEndpointからワーカーのリソース情報・Executor一覧・ドライバー一覧を取得して表示 |
| 5 | Executorプロセス管理 | 補助機能 | ワーカー上で実行中のExecutorRunner情報（コア数・メモリ・状態）を表示 |

## 画面種別

一覧（ダッシュボード）

## URL/ルーティング

- **URL**: `/`（WorkerWebUIのルート）
- **HTTPメソッド**: GET
- **JSON API**: renderJsonメソッドによるJSON応答
- **ページ名（WebUIPage）**: `""` （デフォルトページ）

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|------|------|------|
| なし（GETパラメータなし） | - | - | - | ワーカー状態はRPCで取得 |

## 表示項目

### ワーカー基本情報セクション

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| ID | workerState.workerId | ワーカー識別子（ワーカーログページへのリンク付き） |
| Master URL | workerState.masterUrl | 接続先マスターURL |
| Cores | workerState.cores, workerState.coresUsed | 総コア数（使用コア数） |
| Memory | workerState.memory, workerState.memoryUsed | 総メモリ（使用メモリ） |
| Resources | workerState.resources, workerState.resourcesUsed | カスタムリソースの使用/空き詳細 |
| Back to Master | workerState.masterWebUiUrl | マスターUI画面へのリンク |

### Running Executorsテーブル

| カラム名 | 説明 |
|----------|------|
| ExecutorID | エグゼキュータ識別子 |
| State | エグゼキュータ状態 |
| Cores | 割り当てコア数 |
| Memory | 割り当てメモリ |
| Resources | 割り当てリソース |
| Job Details | アプリケーション情報（ID、名前、ユーザー）。実行中かつUIありの場合はアプリ名にリンク付き |
| Logs | stdout/stderrログリンク（Worker UIのlogPageへ） |

### Running Driversテーブル（存在する場合のみ）

| カラム名 | 説明 |
|----------|------|
| DriverID | ドライバー識別子 |
| Main Class | メインクラス名 |
| State | ドライバー状態（RUNNING or finalState） |
| Cores | 使用コア数 |
| Memory | 使用メモリ |
| Resources | 使用リソース |
| Logs | stdout/stderrログリンク |
| Notes | 例外情報（finalException） |

### Finished Executors/Driversテーブル（存在する場合のみ）

Running Executors/Driversテーブルと同一のカラム構成。

## イベント仕様

### 1-ページ読み込み

1. `workerEndpoint.askSync[WorkerStateResponse](RequestWorkerState)` でワーカー状態をRPCで取得する
2. ワーカー基本情報を表示する
3. Running Executorsテーブルを表示する
4. Running Driversテーブルを表示する（存在する場合のみ）
5. Finished Executorsテーブルを表示する（存在する場合のみ）
6. Finished Driversテーブルを表示する（存在する場合のみ）

### 2-JSON API応答

`renderJson` メソッドにより `JsonProtocol.writeWorkerState(workerState)` でJSON応答が生成される。

### 3-ログリンク押下

Logs列のstdout/stderrリンクをクリックすると、Worker UIのlogPageに遷移する。
- エグゼキュータログ: `{workerUrl}/logPage/?appId={appId}&executorId={execId}&logType=stdout|stderr`
- ドライバーログ: `{workerUrl}/logPage/?driverId={driverId}&logType=stdout|stderr`

### 4-アプリケーション名リンク押下

Job Details列のアプリケーション名リンクをクリックすると、Spark Application UIに遷移する。エグゼキュータがRUNNING状態でappUiUrlが設定されている場合にのみリンクが有効。

### 5-テーブル折りたたみ

各テーブルのヘッダをクリックすると、`collapseTable` JavaScript関数で表示/非表示が切り替わる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ読み込み | WorkerEndpoint | RPC/SELECT | RequestWorkerStateでワーカー状態を取得 |

### テーブル別更新項目詳細

#### WorkerStateResponse（RPC応答）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| SELECT | workerId, host, port, masterUrl, masterWebUiUrl | - | ワーカー基本情報 |
| SELECT | cores, coresUsed, memory, memoryUsed | - | リソース情報 |
| SELECT | resources, resourcesUsed | - | カスタムリソース情報 |
| SELECT | executors | - | 実行中エグゼキュータ一覧（ExecutorRunner） |
| SELECT | finishedExecutors | - | 終了済みエグゼキュータ一覧 |
| SELECT | drivers | - | 実行中ドライバー一覧（DriverRunner） |
| SELECT | finishedDrivers | - | 終了済みドライバー一覧 |

## メッセージ仕様

特になし。

## 例外処理

| 例外 | 発生条件 | 処理 |
|------|----------|------|
| RPC通信エラー | WorkerEndpointとの通信が失敗した場合 | Spark UIフレームワークによるエラーページ表示 |

## 備考

- ページタイトルは "Spark Worker at {host}:{port}"
- ドライバーIDはdriverId降順でソートされて表示される
- reverseProxy設定時はワーカーID、アプリケーションUIリンクがプロキシ経由パスとなる
- Running Drivers/Finished Executors/Finished Driversセクションはそれぞれ要素が存在する場合のみ表示される
- ドライバーのStateは `driver.finalState.getOrElse(DriverState.RUNNING)` で表示される
- ドライバーのNotesは `driver.finalException.getOrElse("")` で表示される
- リソース詳細はformatResourcesDetailsで「Used/Free」形式で表示される
- JSON APIは `JsonProtocol.writeWorkerState` で生成される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DeployMessages.scala | `core/src/main/scala/org/apache/spark/deploy/DeployMessages.scala` | WorkerStateResponse: workerId, host, port, masterUrl, masterWebUiUrl, cores, coresUsed, memory, memoryUsed, resources, resourcesUsed, executors, finishedExecutors, drivers, finishedDrivers |
| 1-2 | ExecutorRunner.scala | `core/src/main/scala/org/apache/spark/deploy/worker/ExecutorRunner.scala` | ExecutorRunner: execId, appId, appDesc, cores, memory, state, resources, workerId |
| 1-3 | DriverRunner.scala | `core/src/main/scala/org/apache/spark/deploy/worker/DriverRunner.scala` | DriverRunner: driverId, driverDesc, finalState, finalException, resources |

**読解のコツ**: ExecutorRunnerはワーカー上でのエグゼキュータプロセス管理クラスであり、appDescにアプリケーション情報（name, user, appUiUrl）が含まれる。DriverRunnerもワーカー上でのドライバープロセス管理クラス。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | WorkerPage.scala | `core/src/main/scala/org/apache/spark/deploy/worker/ui/WorkerPage.scala` | renderメソッド（56-163行目）: WorkerStateResponseの取得、エグゼキュータ/ドライバーテーブルの生成、HTML構成 |

**主要処理フロー**:
1. **57行目**: `workerEndpoint.askSync[WorkerStateResponse](RequestWorkerState)` でワーカー状態取得
2. **59-66行目**: エグゼキュータテーブル生成（running/finished）
3. **68-75行目**: ドライバーテーブル生成（running/finished、ID降順ソート）
4. **82-160行目**: HTML構成（基本情報、Running Executors、Running/Finished Drivers、Finished Executors）
5. **161-162行目**: `UIUtils.basicSparkPage` でHTMLレスポンス生成

#### Step 3: 行レンダリングの理解

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | WorkerPage.scala | `core/src/main/scala/org/apache/spark/deploy/worker/ui/WorkerPage.scala` | executorRow（165-202行目）: エグゼキュータ行のレンダリング。Job Details列にアプリID・名前・ユーザーを表示。driverRow（204-225行目）: ドライバー行のレンダリング。finalState/finalExceptionの表示 |

### プログラム呼び出し階層図

```
WorkerPage.render(request)
    |
    +-- workerEndpoint.askSync[WorkerStateResponse](RequestWorkerState)
    |
    +-- Running Executorsテーブル
    |       +-- UIUtils.listingTable(executorHeaders, executorRow, runningExecutors)
    |               +-- executorRow(executor)
    |                       +-- UIUtils.makeHref(reverseProxy, workerId, webUrl) [ワーカーURL]
    |                       +-- UIUtils.makeHref(reverseProxy, appId, appUiUrl) [アプリURL]
    |
    +-- Running Driversテーブル（存在時のみ）
    |       +-- UIUtils.listingTable(driverHeaders, driverRow, runningDrivers)
    |
    +-- Finished Executorsテーブル（存在時のみ）
    |       +-- UIUtils.listingTable(executorHeaders, executorRow, finishedExecutors)
    |
    +-- Finished Driversテーブル（存在時のみ）
    |       +-- UIUtils.listingTable(driverHeaders, driverRow, finishedDrivers)
    |
    +-- UIUtils.basicSparkPage(request, content, title)

WorkerPage.renderJson(request)
    |
    +-- workerEndpoint.askSync[WorkerStateResponse](RequestWorkerState)
    +-- JsonProtocol.writeWorkerState(workerState)
```

### データフロー図

```
[入力]                       [処理]                           [出力]

HTTPリクエスト           ───> WorkerPage.render               ───> HTML Page / JSON
                              |                                  |
WorkerEndpoint           ───> askSync(RequestWorkerState)    ───> ワーカー基本情報
  +-- ExecutorRunner[]         |                                  +-- Running Executors
  +-- DriverRunner[]           |                                  +-- Running Drivers
  +-- finishedExecutors        |                                  +-- Finished Executors
  +-- finishedDrivers          |                                  +-- Finished Drivers
                              |
                         UIUtils.listingTable()
                         UIUtils.basicSparkPage()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| WorkerPage.scala | `core/src/main/scala/org/apache/spark/deploy/worker/ui/WorkerPage.scala` | ソース | ワーカー概要画面のメインページクラス |
| WorkerWebUI.scala | `core/src/main/scala/org/apache/spark/deploy/worker/ui/WorkerWebUI.scala` | ソース | WorkerWebUIの初期化、ページ登録 |
| DeployMessages.scala | `core/src/main/scala/org/apache/spark/deploy/DeployMessages.scala` | ソース | RPCメッセージ定義（RequestWorkerState, WorkerStateResponse） |
| JsonProtocol.scala | `core/src/main/scala/org/apache/spark/deploy/JsonProtocol.scala` | ソース | JSON API応答の生成 |
| ExecutorRunner.scala | `core/src/main/scala/org/apache/spark/deploy/worker/ExecutorRunner.scala` | ソース | エグゼキュータプロセス管理クラス |
| DriverRunner.scala | `core/src/main/scala/org/apache/spark/deploy/worker/DriverRunner.scala` | ソース | ドライバープロセス管理クラス |
| StandaloneResourceUtils.scala | `core/src/main/scala/org/apache/spark/deploy/StandaloneResourceUtils.scala` | ソース | リソースフォーマットユーティリティ |
| UIUtils.scala | `core/src/main/scala/org/apache/spark/ui/UIUtils.scala` | ソース | HTML生成ユーティリティ |
